package tech.glinfo.enbao.modules.sh.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import tech.glinfo.enbao.common.utils.Constant;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sh.dao.OtherShDeviceRecordDao;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceRecordEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceRecordService;

import java.util.List;
import java.util.Map;


@Service("otherShDeviceRecordService")
public class OtherShDeviceRecordServiceImpl extends ServiceImpl<OtherShDeviceRecordDao, ShDeviceRecordEntity> implements OtherShDeviceRecordService {

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        int current = Integer.parseInt((String) params.get(Constant.PAGE));
        int size = Integer.parseInt((String) params.get(Constant.LIMIT));
        Page<Map<String, Object>> page = new Page<>(current, size);
        List<Map<String, Object>> list = this.baseMapper.list(page, params);
        page.setRecords(list);
        return new PageUtils(page);
    }

    @Override
    public R switchOutletRecord(Map<String, Object> params) {
        List<Map<String, Object>> list = this.baseMapper.list1(params);
        return R.ok().put("list", list);
    }

    @Override
    public R clearRemark(Integer deviceId) {

        ShDeviceRecordEntity entity = this.getOne(new QueryWrapper<ShDeviceRecordEntity>().eq("device_id", deviceId).orderByDesc("id").last("LIMIT 1"));
        this.baseMapper.clearRemark(deviceId);
        this.updateById(entity);
        return R.ok();
    }

}