package tech.glinfo.enbao.modules.sh.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.contants.Constants;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.modules.sh.entity.ShSpeakerSecondaryKeywordsEntity;
import tech.glinfo.enbao.modules.sh.service.SecondaryKeywordsService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


/**
 * 智能音箱二级关键字
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2021-06-29 15:57:11
 */
@RestController
@RequestMapping("sh/speakersecondarykeywords")
public class ShSpeakerSecondaryKeywordsController {

    @Autowired
    private SecondaryKeywordsService secondaryKeywordsService;

    @Autowired
    private RedisUtils redisUtils;

    /**
     * 列表
     */
    @RequestMapping("/list")
    @RequiresPermissions("sh:speakersecondarykeywords:list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = secondaryKeywordsService.queryPage(params);

        return R.ok().put("page", page);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    @RequiresPermissions("sh:speakersecondarykeywords:info")
    public R info(@PathVariable("id") Integer id){
		ShSpeakerSecondaryKeywordsEntity speakerSecondaryKeywords = secondaryKeywordsService.getById(id);

        return R.ok().put("speakerSecondaryKeywords", speakerSecondaryKeywords);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    @RequiresPermissions("sh:speakersecondarykeywords:save")
    public R save(@RequestBody ShSpeakerSecondaryKeywordsEntity speakerSecondaryKeywords){
        secondaryKeywordsService.save(speakerSecondaryKeywords);
        redisUtils.delete(Constants.DEVICE_KEYWORD_ONE + "-" + speakerSecondaryKeywords.getParentId());
        List<ShSpeakerSecondaryKeywordsEntity> list = secondaryKeywordsService.list(new QueryWrapper<ShSpeakerSecondaryKeywordsEntity>().eq("parent_id", speakerSecondaryKeywords.getParentId()).orderByDesc("id"));
        if (list.size() > 0) {
            //更新缓存
            redisUtils.set(Constants.DEVICE_KEYWORD_ONE + "-" + speakerSecondaryKeywords.getParentId(), list);
        }

        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    @RequiresPermissions("sh:speakersecondarykeywords:update")
    public R update(@RequestBody ShSpeakerSecondaryKeywordsEntity speakerSecondaryKeywords){
        secondaryKeywordsService.updateById(speakerSecondaryKeywords);
        redisUtils.delete(Constants.DEVICE_KEYWORD_ONE + "-" + speakerSecondaryKeywords.getParentId());

        List<ShSpeakerSecondaryKeywordsEntity> list = secondaryKeywordsService.list(new QueryWrapper<ShSpeakerSecondaryKeywordsEntity>().eq("parent_id", speakerSecondaryKeywords.getParentId()).orderByDesc("id"));
        if (list.size() > 0) {
            //更新缓存
            redisUtils.set(Constants.DEVICE_KEYWORD_ONE + "-" + speakerSecondaryKeywords.getParentId(), list);
        }
        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    @RequiresPermissions("sh:speakersecondarykeywords:delete")
    public R delete(@RequestBody Integer[] ids){
        List<ShSpeakerSecondaryKeywordsEntity> list = secondaryKeywordsService.list(new QueryWrapper<ShSpeakerSecondaryKeywordsEntity>().in("id", Arrays.asList(ids)));
        secondaryKeywordsService.removeByIds(Arrays.asList(ids));
        List<Integer> list1 = new ArrayList<>();
        for (ShSpeakerSecondaryKeywordsEntity entity : list) {
            if (!list1.contains(entity.getParentId())) {
                redisUtils.delete(Constants.DEVICE_KEYWORD_ONE + "-" + entity.getParentId());
                List<ShSpeakerSecondaryKeywordsEntity> list2 = secondaryKeywordsService.list(new QueryWrapper<ShSpeakerSecondaryKeywordsEntity>().eq("parent_id", entity.getParentId()).orderByDesc("id"));
                if (list2.size() > 0) {
                    //更新缓存
                    redisUtils.set(Constants.DEVICE_KEYWORD_ONE + "-" + entity.getParentId(), list2);
                }
                list1.add(entity.getParentId());
            }

        }

        return R.ok();
    }

}
