package tech.glinfo.enbao.modules.sh.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tech.glinfo.enbao.modules.sh.dto.ShFamilyDto;
import tech.glinfo.enbao.modules.sh.dto.ShFamilyIndex;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyEntity;

import java.util.List;
import java.util.Map;

/**
 * @author lyt
 * @date 2022/1/5 10:50
 */
@Mapper
public interface OtherShFamilyDao extends BaseMapper<ShFamilyEntity> {


    @Select("<script>" +
            "DELETE t1, t2, t3, t4 FROM sh_family AS t1 LEFT JOIN sh_family_member AS t2 ON t1.id = t2.family_id " +
            "LEFT JOIN sh_family_room AS t3 ON t1.id = t3.family_id LEFT JOIN sh_device AS t4 ON t1.id = t4.family_id " +
            "WHERE t1.id = ${id}" +
            " </script>")
    void delete(Integer id);

    @Select("<script>" +
            "SELECT a.id, a.name, (SELECT COUNT(c.id) FROM sh_family_room c WHERE a.id = c.family_id) room FROM sh_family a ,sh_family_member b WHERE a.id = b.family_id AND b.user_id = ${userId}" +
            " </script>")
    List<Map<String, Object>> list(Integer userId);


    ShFamilyDto familyInfo(@Param("id")Integer id);

    ShFamilyIndex index(@Param("userId")Integer userId, @Param("familyId")String familyId);
}
