package tech.glinfo.enbao.modules.sys.controller;

import java.util.Arrays;
import java.util.Map;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import tech.glinfo.enbao.modules.sys.entity.BusinessCooperationEntity;
import tech.glinfo.enbao.modules.sys.service.BusinessCooperationService;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.R;



/**
 * 商务合作
 *
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2022-02-14 16:39:15
 */
@RestController
@RequestMapping("sys/businesscooperation")
public class BusinessCooperationController {
    @Autowired
    private BusinessCooperationService businessCooperationService;

    /**
     * 列表
     */
    @RequestMapping("/list")
    public R list(@RequestParam Map<String, Object> params){
        PageUtils page = businessCooperationService.queryPage(params);

        return R.ok().put("page", page);
    }


    /**
     * 信息
     */
    @RequestMapping("/info/{id}")
    public R info(@PathVariable("id") Integer id){
		BusinessCooperationEntity businessCooperation = businessCooperationService.getById(id);

        return R.ok().put("businessCooperation", businessCooperation);
    }

    /**
     * 保存
     */
    @RequestMapping("/save")
    public R save(@RequestBody BusinessCooperationEntity businessCooperation){
		businessCooperationService.save(businessCooperation);

        return R.ok();
    }

    /**
     * 修改
     */
    @RequestMapping("/update")
    public R update(@RequestBody BusinessCooperationEntity businessCooperation){
		businessCooperationService.updateById(businessCooperation);

        return R.ok();
    }

    /**
     * 删除
     */
    @RequestMapping("/delete")
    public R delete(@RequestBody Integer[] ids){
		businessCooperationService.removeByIds(Arrays.asList(ids));

        return R.ok();
    }

}
