package tech.glinfo.enbao.modules.sh.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import tech.glinfo.enbao.common.utils.Constant;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.sh.dao.OtherShDeviceDao;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceService;

import java.util.List;
import java.util.Map;

/**
 * @author linyetong
 * @date 2019/12/13 12:29
 */

@Service("otherShDeviceService")
public class OtherShDeviceServiceImpl extends ServiceImpl<OtherShDeviceDao, ShDeviceEntity> implements OtherShDeviceService {


    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        int current = Integer.parseInt((String)params.get(Constant.PAGE));
        int size = Integer.parseInt((String)params.get(Constant.LIMIT));
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(current, size);
        String time = (String) params.get("createTime");
        String start = null;
        String end = null;
        if (StringUtils.isNotBlank(time)) {
            start = time + " 00:00:00";
            end = time + " 59:59:59";
        }
        System.out.println(start);
        System.out.println(end);
        params.put("start", start);
        params.put("end", end);
        page.setRecords(this.baseMapper.list(page, params));
        return new PageUtils(page);
    }

    @Override
    public Map<String, Object> info(Integer id) {
        return this.baseMapper.info(id);
    }


    @Override
    public void timeout() {
        List<Map<String, Object>> list = this.baseMapper.timeout();
        for (Map<String, Object> map : list) {
            ShDeviceEntity entity = new ShDeviceEntity();
            entity.setId((Integer) map.get("id"));
            entity.setOnlineStatus(3);
            this.updateById(entity);
        }

        //智能锁密码过期
        this.baseMapper.updateDevicePassword();
    }


}
