package tech.glinfo.enbao.modules.sys.controller;


import tech.glinfo.enbao.common.controller.AbstractController;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sys.service.SysConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * 系统参数
 *
 * @author Mark sunlightcs@gmail.com
 */
@RestController
@RequestMapping("/sys/config")
@Api(value = "系统参数",description="系统参数相关接口")
public class SysConfigController extends AbstractController {
	@Autowired
	private SysConfigService sysConfigService;

	/**
	 * 配置信息
	 */
	@GetMapping("/info/{key}")
	@ApiOperation("根据键值获取值")
	public R info(@PathVariable("key") String key){
		String config = sysConfigService.getValue(key);
		
		return R.ok().put("value", config);
	}

	/**
	 * 配置信息
	 */
	@GetMapping("/get/{key}")
	@ApiOperation("根据键值获取值")
	public String get(@PathVariable("key") String key) throws IOException {
		String value = sysConfigService.getValue(key);
		logger.debug(value);
		return value;
	}

}
