package tech.glinfo.enbao.modules.sh.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.DateUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceCategoryEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceTimingEntity;
import tech.glinfo.enbao.modules.sh.form.ShDeviceCategoryForm;
import tech.glinfo.enbao.modules.sh.form.ShDeviceTimingForm;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceTimingService;
import tech.glinfo.enbao.modules.sh.service.ShDeviceCategoryService;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/shDeviceCategory")
@Api(value = "设备分类")
public class ShDeviceCategoryController {


    @Autowired
    private ShDeviceCategoryService shDeviceCategoryService;

    @Login
    @PostMapping("saveOrUpdate")
    @ApiOperation("新增、修改")
    @ApiLog("新增、修改")
    public R saveOrUpdate(@RequestBody ShDeviceCategoryForm form, @LoginUser AppUserEntity user) throws InvocationTargetException, IllegalAccessException {
        //表单校验
        ValidatorUtils.validateEntity(form);
        ShDeviceCategoryEntity categoryEntity = new ShDeviceCategoryEntity();
        BeanUtils.copyProperties(categoryEntity, form);
        categoryEntity.setUserId(user.getId());
        return shDeviceCategoryService.saveOrUpdate(categoryEntity) ? R.ok() : R.error("操作失败");
    }

    @Login
    @GetMapping("list")
    @ApiOperation("列表")
    @ApiLog("列表")
    public R list(@LoginUser AppUserEntity user) {
        List<ShDeviceCategoryEntity> list = shDeviceCategoryService.list(new QueryWrapper<ShDeviceCategoryEntity>().eq("userId", user.getId()));
        return R.ok().put("list", list);
    }


    @Login
    @GetMapping("info/{id}")
    @ApiOperation("详情")
    @ApiLog("详情")
    public R info(@PathVariable("id") Integer id) {
        return R.ok().put("category", shDeviceCategoryService.getById(id));
    }

    @Login
    @PostMapping("delete")
    @ApiOperation("删除")
    @ApiLog("删除定时")
    public R delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        if (StringUtils.isBlank(id)) {
            return R.error("缺少参数");
        }
        return shDeviceCategoryService.removeById(id) ? R.ok() : R.error("操作失败");
    }

}