package tech.glinfo.enbao.modules.sh.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 智能家居定时表
 * 
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2021-12-24 14:20:55
 */
@Data
@TableName("sh_device_timing")
public class ShDeviceTimingEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键id
	 */
	@TableId
	private Integer id;
	/**
	 * 设备ID
	 */
	private Integer deviceId;
	/**
	 * 状态 0:一次 1:多次
	 */
	private Integer repeats;
	/**
	 * 打开时间 重复一次时间：2020-04-20 15:12;重复多次时间：15:20
	 */
	private String time;
	/**
	 * 重复时间 1 2 3 4 5 6 7
	 */
	private String repeatTime;
	/**
	 * 开关1:1为选中，其他为不选中
	 */
	private Integer action;
	/**
	 * 开关2:1为选中，其他为不选中
	 */
	private Integer actionTwo;
	/**
	 * 关闭时间 重复一次时间：2020-04-20 15:12;重复多次时间：15:20
	 */
	private String closeTime;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 状态 1开 2关
	 */
	private Integer status;

}
