package tech.glinfo.enbao.modules.sh.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyMemberEntity;
import tech.glinfo.enbao.modules.sh.service.ShFamilyMemberService;

import java.util.Map;


@RestController
@RequestMapping("/shFamilyMember")
@Api(value = "家庭成员")
public class ShFamilyMemberController {

    @Autowired
    private ShFamilyMemberService shFamilyMemberService;

    /*@Login
    @PostMapping("add")
    @ApiOperation("新增")
    @ApiLog("新增")
    public R add(@RequestBody Map<String, Object> params, @LoginUser AppUserEntity user) {
        Integer familyId = (Integer) params.get("familyId");
        if (StringUtils.isBlank(familyId)) {
            return R.error("缺少参数");
        }
        ShFamilyMemberEntity member = new ShFamilyMemberEntity();
        member.setFamilyId(familyId);
        member.setUserId(user.getId());
        member.setIsAdmin(2);
        shFamilyMemberService.save(member);
        return R.ok();
    }*/


    @Login
    @PostMapping("delete")
    @ApiOperation("删除")
    @ApiLog("删除")
    public R delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        ShFamilyMemberEntity member = shFamilyMemberService.getById(id);
        if (member.getIsAdmin() == 1) {
            return R.error("不能删除管理员");
        }
        shFamilyMemberService.removeById(id);
        return R.ok();
    }

}