package tech.glinfo.enbao.modules.mq;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;
import tech.glinfo.enbao.common.contants.AppContants;
import tech.glinfo.enbao.common.utils.AppPush;
import tech.glinfo.enbao.modules.upgrade.service.UpgradeService;

import java.util.Map;

@Component
public class MqConsumer {

    private final static Logger logger = LoggerFactory.getLogger(MqConsumer.class);

    @Autowired
    private AppPush appPush;

    @Autowired
    private UpgradeService upgradeService;


    /**
     * 接收app推送消息
     * @param message
     */
    @JmsListener(destination = AppContants.PUSH_QUEUE, containerFactory = "jmsListenerContainerQueue")
    public void pushQueue(String message) {
        logger.info("报文为：{}，主题:{}", message, AppContants.PUSH_QUEUE);
        Map<String, String> datas = (Map<String, String>) JSON.parse(message);
        if(datas.get("title") != null && datas.get("content") != null && datas.get("clientId") != null) {
            appPush.push(datas.get("title"), datas.get("content"), datas.get("clientId"));
        }
    }

    /**
     * 接收升级指令消息
     * @param message
     */
    @JmsListener(destination = AppContants.RECEIVE_UPGRADE_QUEUE, containerFactory = "jmsListenerContainerQueue")
    public void upgradeQueue(String message) {
        logger.info("报文为：{}，主题:{}", message, AppContants.RECEIVE_UPGRADE_QUEUE);
        upgradeService.defeedback(message);
    }
}
