package tech.glinfo.enbao.modules.sys.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sys.entity.HelpCenterContentEntity;
import tech.glinfo.enbao.modules.sys.service.HelpCenterContentService;
import tech.glinfo.enbao.modules.sys.service.HelpCenterService;

/**
 * @author lyt
 * @date 2022/2/14 18:07
 */
@RestController
@RequestMapping("/sys/helpCenter")
@Api(value = "帮助中心")
public class HelpCenterController {

    @Autowired
    private HelpCenterService helpCenterService;

    @Autowired
    private HelpCenterContentService helpCenterContentService;

    /**
     * 列表
     */
    @GetMapping("/list")
    @ApiOperation("帮助中心")
    public R list(){

        return R.ok().put("list", helpCenterService.list());
    }


    /**
     * 详情
     */
    @GetMapping("/info/{id}")
    @ApiOperation("帮助中心")
    public R info(@PathVariable("id") Integer id){

        return R.ok().put("list", helpCenterContentService.list(new QueryWrapper<HelpCenterContentEntity>().eq("help_id", id)));
    }
}
