package tech.glinfo.enbao.config;

import tech.glinfo.enbao.common.contants.AppContants;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;

import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;

@Configuration
public class MyActiveMqConfig {
    @Bean
    public Queue sendQueue() {
        return new ActiveMQQueue(AppContants.RECEIVE_QUEUE);
    }
    @Bean
    public Queue sendPushQueue() {
        return new ActiveMQQueue(AppContants.PUSH_QUEUE);
    }
    @Bean
    public Topic sendTopic(){
        return new ActiveMQTopic(AppContants.SEND_TOPIC);
    }
    @Bean
    public Topic websocketTopic(){
        return new ActiveMQTopic(AppContants.WEBSOCKET_TOPIC);
    }

    //Topic模式
    @Bean
    public JmsListenerContainerFactory<?> jmsListenerContainerTopic(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory bean = new DefaultJmsListenerContainerFactory();
        bean.setPubSubDomain(true);
        bean.setConnectionFactory(connectionFactory);
        return bean;
    }
    //Queue模式
    @Bean
    public JmsListenerContainerFactory<?> jmsListenerContainerQueue(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory bean = new DefaultJmsListenerContainerFactory();
        bean.setConnectionFactory(connectionFactory);
        return bean;
    }
}