package tech.glinfo.enbao.common.utils;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class NumberingUtils {

    @Autowired
    private RedisUtils redisUtils;

    public synchronized List<Map<String, Object>> nextId1(int count, String type) {
        List<Map<String, Object>> set = new ArrayList<>();

        String format = LocalDate.now().format(DateTimeFormatter.ofPattern("YY"));
        String format1 = LocalDate.now().format(DateTimeFormatter.ofPattern("w"));
        StringBuffer format2 = new StringBuffer();
        format2.append(format);
        if (format1.length() == 1) {
            format2.append("0");
        }
        format2.append(format1);
        String numbering = redisUtils.get(format2.toString() + type);
        int numbering1;
        if (numbering == null) {
            numbering1 = 1;
        }else {
            numbering1 = Integer.parseInt(numbering);
        }

        for (int i = 0; i < count; i++) {
            if (numbering1 > 99999) {
                break;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(type);
            sb.append("EB");

            sb.append(format2.toString());
            sb.append(String.format("%05d", numbering1));
            Map<String, Object> map = new HashMap<>();
            map.put("numbering", sb.toString());
            map.put("code", NumberingUtil.getCode(sb.toString()));
            set.add(map);
            numbering1 ++;
        }
        redisUtils.set(format2.toString() + type, numbering1, 60 * 60 * 24 * 7);

        return set;
    }

    public synchronized List<Map<String, Object>> nextId(int count) {
        List<Map<String, Object>> set = new ArrayList<>();

        String format = LocalDate.now().format(DateTimeFormatter.ofPattern("YY"));
        String format1 = LocalDate.now().format(DateTimeFormatter.ofPattern("w"));
        StringBuffer format2 = new StringBuffer();
        format2.append(format);
        if (format1.length() == 1) {
            format2.append("0");
        }
        format2.append(format1);
        String numbering = redisUtils.get(format2.toString());
        int numbering1;
        if (numbering == null) {
            numbering1 = 1;
        }else {
            numbering1 = Integer.parseInt(numbering);
        }

        for (int i = 0; i < count; i++) {
            if (numbering1 > 99999) {
                break;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("001EB");

            sb.append(format2.toString());
            sb.append(String.format("%05d", numbering1));
            Map<String, Object> map = new HashMap<>();
            map.put("numbering", sb.toString());
            set.add(map);
            numbering1 ++;
        }
        redisUtils.set(format2.toString(), numbering1, 60 * 60 * 24 * 7);

        return set;
    }
}
