package tech.glinfo.enbao.modules.sh.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.sh.service.OtherShDevicePowerService;

import java.util.Map;

/**
 * @Author lyt
 * @Date 2019/12/21 21:03
 */

@RestController
@RequestMapping("/shDevicePower")
@Api(value = "设备电量查询")
public class ShDevicePowerController {

    @Autowired
    private OtherShDevicePowerService otherShDevicePowerService;


    @GetMapping("powerQuery")
    @ApiOperation("根据设备ID查询电量")
    @ApiLog("根据设备ID查询电量")
    public R powerQuery(@RequestParam Map<String, Object> params){
        return otherShDevicePowerService.powerQuery(params);
    }
}
