package tech.glinfo.enbao.modules.sh.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.appuser.service.AppUserService;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyMemberEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShFamilyMemberService;
import tech.glinfo.enbao.modules.sh.service.ShFamilyMemberService;

import java.util.Map;


@RestController
@RequestMapping("/shFamilyMember")
@Api(value = "家庭成员")
public class ShFamilyMemberController {

    @Autowired
    private OtherShFamilyMemberService otherShFamilyMemberService;

    @Autowired
    private AppUserService appUserService;

    @Login
    @PostMapping("add")
    @ApiOperation("新增")
    @ApiLog("新增")
    public R add(@RequestBody Map<String, Object> params, @LoginUser AppUserEntity user) {
        String phone = (String) params.get("phone");
        Integer familyId = (Integer) params.get("familyId");
        if (StringUtils.isBlank(familyId)) {
            return R.error("缺少参数");
        }
        if (StringUtils.isBlank(phone)) {
            return R.error("请输入邀请成员手机号码");
        }
        AppUserEntity appUser = appUserService.getOne(new QueryWrapper<AppUserEntity>().eq("phone", phone));
        if (appUser == null) {
            return R.error("成员还未注册");
        }
        int count = otherShFamilyMemberService.count(new QueryWrapper<ShFamilyMemberEntity>().eq("user_id", appUser.getId()).eq("family_id", familyId).in("status", 1, 2));
        if (count > 0) {
            return R.error("请勿重复邀请");
        }
        ShFamilyMemberEntity member = new ShFamilyMemberEntity();
        member.setFamilyId(familyId);
        member.setUserId(appUser.getId());
        member.setIsAdmin(2);
        member.setInviteId(user.getId());
        otherShFamilyMemberService.save(member);

        return R.ok();
    }

    @Login
    @GetMapping("list")
    @ApiOperation("邀请列表")
    @ApiLog("邀请列表")
    public R list(@LoginUser AppUserEntity user) {
        return otherShFamilyMemberService.list(user.getId());
    }



    @Login
    @PostMapping("updateStatus")
    @ApiOperation("修改状态")
    @ApiLog("修改状态")
    public R updateStatus(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        Integer status = (Integer) params.get("status");
        if (StringUtils.isBlank(id, status)) {
            return R.error("缺少参数");
        }
        ShFamilyMemberEntity member = otherShFamilyMemberService.getById(id);
        if (member != null && member.getStatus() == 1) {
            member.setStatus(status);
            otherShFamilyMemberService.updateById(member);
        }
        return R.ok();
    }

    @Login
    @PostMapping("delete")
    @ApiOperation("删除")
    @ApiLog("删除")
    public R delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        ShFamilyMemberEntity member = otherShFamilyMemberService.getById(id);
        if (member.getIsAdmin() == 1) {
            return R.error("不能删除管理员");
        }
        otherShFamilyMemberService.removeById(id);
        return R.ok();
    }

}