package tech.glinfo.enbao.modules.sh.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShFamilyService;

import java.util.Map;


@RestController
@RequestMapping("/shFamily")
@Api(value = "家庭管理")
public class ShFamilyController {

    @Autowired
    private OtherShFamilyService otherShFamilyService;

    @Login
    @PostMapping("add")
    @ApiOperation("新增")
    @ApiLog("新增")
    public R add(@RequestBody Map<String, Object> params, @LoginUser AppUserEntity user) {
        return otherShFamilyService.add(params, user);
    }

    @Login
    @PostMapping("update")
    @ApiOperation("修改")
    @ApiLog("修改")
    public R update(@RequestBody Map<String, Object> params) {
        return otherShFamilyService.update(params);
    }

    @Login
    @GetMapping("list")
    @ApiOperation("列表")
    @ApiLog("列表")
    public R list(@LoginUser AppUserEntity user) {
        return otherShFamilyService.list(user);
    }


    @Login
    @GetMapping("info/{id}")
    @ApiOperation("详情")
    @ApiLog("详情")
    public R info(@PathVariable("id") Integer id) {
        return otherShFamilyService.info(id);
    }

    @Login
    @PostMapping("delete")
    @ApiOperation("删除")
    @ApiLog("删除")
    public R delete(@RequestBody Map<String, Object> params, @LoginUser AppUserEntity user) {

        return otherShFamilyService.delete(params, user);
    }

    @Login
    @GetMapping("index")
    @ApiOperation("首页")
    @ApiLog("首页")
    public R index(@RequestParam Map<String, String> params, @LoginUser AppUserEntity user) {
        return otherShFamilyService.index(user.getId(), params.get("familyId"));
    }

}