package tech.glinfo.enbao.modules.sh.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceDataEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;

import java.util.List;
import java.util.Map;

/**
 * @author linyetong
 * @date 2020/1/13 9:32
 */
@Mapper
public interface OtherShDeviceDao extends BaseMapper<ShDeviceEntity> {

    @Select("<script>" +
            "SELECT * FROM sh_device_data a, sh_device b WHERE a.device_id = b.id AND b.numbering = #{numbering}" +
            " </script>")
    ShDeviceDataEntity getDeviceDataByNumbering(String numbering);

    @Select("<script>" +
            "SELECT * FROM sh_device a WHERE a.user_id = ${userId}" +
            " </script>")
    List<ShDeviceEntity> getDeviceByFlag(Integer userId);

    @Update("<script>" +
            "UPDATE sh_device SET room_id = null WHERE id = ${id}" +
            " </script>")
    void deleteRelation(Integer id);


    @Select("<script>" +
            "SELECT a.id, a.numbering, a.numbering_flag numberingFlag, a.name, a.online_status onlineStatus, a.pic, a.spare_one spareOne, a.spare_two spareTwo, b.name roomName FROM sh_device a LEFT JOIN sh_family_room b ON a.room_id = b.id WHERE a.id = ${id}" +
            " </script>")
    Map<String, Object> index(Integer id);
}
