package tech.glinfo.enbao.modules.sh.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.DateUtils;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.modules.mq.MqProducer;
import tech.glinfo.enbao.modules.sh.dao.OtherShDeviceTimingDao;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceTimingEntity;
import tech.glinfo.enbao.modules.sh.form.ProtocolContent;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceTimingService;
import tech.glinfo.enbao.modules.sh.service.ShDeviceService;

import java.util.*;

@Service("otherShDeviceTimingService")
public class OtherShDeviceTimingServiceImpl extends ServiceImpl<OtherShDeviceTimingDao, ShDeviceTimingEntity> implements OtherShDeviceTimingService {

    private final static Logger logger = LoggerFactory.getLogger(OtherShDeviceTimingServiceImpl.class);


    @Autowired
    private ShDeviceService shDeviceService;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private MqProducer mqProducer;


    @Override
    public void listTimingByTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int week = cal.get(Calendar.DAY_OF_WEEK) - 1;//获取星期几
        Map<String, Object> params = new HashMap<>();
        params.put("time1", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm"));
        params.put("time2", DateUtils.format(new Date(), "HH:mm"));
        params.put("week", week);
        List<ShDeviceTimingEntity> list = this.baseMapper.listTimingByTime(params);
        for (ShDeviceTimingEntity entity : list) {
            ShDeviceEntity entity1 = shDeviceService.getById(entity.getDeviceId());
            if (entity1 != null) {
                ProtocolContent protocol = new ProtocolContent();
                String type = entity1.getNumbering().substring(1, 3);
                switch (type) {
                    case "02": {
                        String action = entity.getAction() == 1 ? "01" : entity.getAction() == 2 ? "00" : "02";
                        String actionTwo = entity.getActionTwo() == 1 ? "01" : entity.getActionTwo() == 2 ? "00" : "02";
                        String content = "";
                        if (entity.getAction() != 0 && entity.getActionTwo() != 0) {
                            content = action + actionTwo + "000000000003";
                        }else if (entity.getAction() != 0) {
                            content = action + "00000000000001";
                        }else if (entity.getActionTwo() != 0) {
                            content = "00"+ actionTwo +"000000000002";
                        }
                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent(content);
                        protocol.setDeviceType(type);
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
                        redisUtils.set(entity1.getNumbering() + "action1", action, 60);
                        redisUtils.set(entity1.getNumbering() + "action2", actionTwo, 60);
//                        logger.info("action1 : {}", redisUtils.get(entity1.getNumbering() + "action"));
                        break;
                    }
                    case "03": {
                        String action = entity.getAction() == 1 ? "01" : "00";
                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent(action + "00000000000000");
                        protocol.setDeviceType(type);
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
                        redisUtils.set(entity1.getNumbering() + "action", action);
                        logger.info("action : {}", redisUtils.get(entity1.getNumbering() + "action"));
                        logger.info("Numbering : {}", entity1.getNumbering());
                        break;
                    }
                    case "04": {
                        String action = entity.getAction() == 1 ? "01" : "00";
                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent(action);
                        protocol.setDeviceType(type);
                        protocol.setCmd("19");
                        mqProducer.sendT(JSON.toJSONString(protocol));
                        /*redisUtils.set(entity1.getNumbering() + "action", action);
                        logger.info("action : {}", redisUtils.get(entity1.getNumbering() + "action"));
                        logger.info("Numbering : {}", entity1.getNumbering());*/
                        break;
                    }
                    case "08": {
                        int action = entity.getAction() == 1 ? 1 : 0;
                        protocol.setReceiveId(entity1.getNumbering());
                        int UVLampStatus = 3;
                        int workingGear = 3;
                        int targetHumidity = 3;
                        if (entity1.getSpareOne() != null) {
                            String[] arr = entity1.getSpareOne().split(",");
                            UVLampStatus = Integer.parseInt(arr[2]);
                            workingGear = Integer.parseInt(arr[1]);
                        }
                        if (entity1.getSpareTwo() != null) {
                            String[] arr = entity1.getSpareTwo().split(",");
                            targetHumidity = Integer.parseInt(arr[1]);
                        }

                        String content = ByteUtils.int2Hex(action) + //工作状态
                                ByteUtils.int2Hex(UVLampStatus == 3 ? 0 : UVLampStatus) + //紫外线状态
                                ByteUtils.int2Hex(workingGear == 3 ? 0 : workingGear) + //工作档位
                                "00" + //自定义档位
                                ByteUtils.int2Hex(targetHumidity == 3 ? 0 : targetHumidity) + //目标湿度
                                "000000";
                        protocol.setContent(content);
                        protocol.setDeviceType("08");
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
                        break;
                    }
                    case "05":
                        int position;
                        if (entity.getAction() == 1) {
                            position = 100;//开启
                        }else {
                            position = 0;//关闭
                        }

                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent("01" + ByteUtils.int2Hex(position) + "000000000000");
                        protocol.setDeviceType("05");
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
//                        redisUtils.set(entity1.getNumbering() + "position", position);
                        break;
                }
            }
        }

    }


    @Override
    public void listTimingByTime1() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int week = cal.get(Calendar.DAY_OF_WEEK) - 1;//获取星期几
        Map<String, Object> params = new HashMap<>();
        params.put("time1", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm"));
        params.put("time2", DateUtils.format(new Date(), "HH:mm"));
        params.put("week", week);
        List<Map<String, Object>> list = this.baseMapper.listTimingByTime1(params);
        for (Map<String, Object> map : list) {
            Integer deviceId = (Integer) map.get("device_id");
            Integer action = (Integer) map.get("action");
            Integer actionTwo = (Integer) map.get("action_two");
            Long flag = (Long) map.get("flag");

            ShDeviceEntity entity1 = shDeviceService.getById(deviceId);
            if (entity1 != null) {
                ProtocolContent protocol = new ProtocolContent();
                String type = entity1.getNumbering().substring(1, 3);
                switch (type) {
                    case "02": {
                        String s = flag == 1 ? "01" : "00";
                        String content = "";
                        if (action != 0 && actionTwo != 0) {
                            content = s + s + "000000000003";
//                            redisUtils.set(entity1.getNumbering() + "action1", flag == 1 ? 1 : 2, 60);
//                            redisUtils.set(entity1.getNumbering() + "action2", flag == 1 ? 3 : 4, 60);
                        }else if (action != 0) {
                            content = s + "00000000000001";
//                            redisUtils.set(entity1.getNumbering() + "action1", flag == 1 ? 1 : 2, 60);
                        }else if (actionTwo != 0) {
                            content = "00"+ s +"000000000002";
//                            redisUtils.set(entity1.getNumbering() + "action2", flag == 1 ? 3 : 4, 60);
                        }
                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent(content);
                        protocol.setDeviceType(type);
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
                        try {
                            Thread.sleep(200);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "03": {
                        String action1 = flag == 1 ? "01" : "00";
                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent(action1 + "00000000000001");
                        protocol.setDeviceType(type);
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
//                        redisUtils.set(entity1.getNumbering() + "action", action1);
                        logger.info("action : {}", redisUtils.get(entity1.getNumbering() + "action"));
                        logger.info("Numbering : {}", entity1.getNumbering());
                        break;
                    }
                    case "04": {
                        String action1 = flag == 1 ? "01" : "00";
                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent(action1);
                        protocol.setDeviceType(type);
                        protocol.setCmd("19");
                        mqProducer.sendT(JSON.toJSONString(protocol));
                        break;
                    }
                    case "05":
                        int position;
                        if (flag == 1) {
                            position = 100;//开启
                        }else {
                            position = 0;//关闭
                        }

                        protocol.setReceiveId(entity1.getNumbering());
                        protocol.setContent("01" + ByteUtils.int2Hex(position) + "000000000000");
                        protocol.setDeviceType("05");
                        protocol.setCmd("18");
                        mqProducer.sendT(JSON.toJSONString(protocol));
//                        redisUtils.set(entity1.getNumbering() + "position", position);
                        break;
                }
            }
        }

    }
}
