package tech.glinfo.enbao.modules.sh.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 智能家居设备管理
 * 
 * @author linyetong
 * @email linyetong@glinfo.com
 * @date 2022-01-05 10:24:13
 */
@Data
@TableName("sh_device")
public class ShDeviceEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键id
	 */
	@TableId
	private Integer id;
	/**
	 * 发布人
	 */
	private Integer userId;
	/**
	 * 家庭ID
	 */
	private Integer familyId;
	/**
	 * 房间ID
	 */
	private Integer roomId;
	/**
	 * mac
	 */
	private String mac;
	/**
	 * 设备编号
	 */
	private String numbering;
	/**
	 * 编号标识
	 */
	private String numberingFlag;
	/**
	 * 设备名称
	 */
	private String name;
	/**
	 * 所属产品
	 */
	private Integer productId;
	/**
	 * 在线状态 1:新增 2:在线 3:离线
	 */
	private Integer onlineStatus;
	/**
	 * 主图
	 */
	private String pic;
	/**
	 * 上线时间
	 */
	private Date onlineTime;
	/**
	 * 备用字段
	 */
	private String spareOne;
	/**
	 * 备用字段
	 */
	private String spareTwo;
	/**
	 * 创建时间
	 */
	private Date createTime;

}
