package tech.glinfo.enbao.common.utils;

public enum ErrorEnventEnum implements IEnventEnum{

    NONE("01", "未识别超时事件"),
    NOCARD("03", "无效卡片事件"),
    NOPWD("04", "密码无效事件"),
    NOFINGER("10", "指纹识别失败事件"),
    NOFACE("11", "人脸识别失败事件"),
    NOPALM("12", "掌静脉识别失败事件"),
    LOCKED("05", "5次未有效操作锁死120S");

    ErrorEnventEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getName(String code) {
        for (ErrorEnventEnum c : ErrorEnventEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.description;
            }
        }
        return null;
    }


    private String code;
    private String description;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
