package tech.glinfo.enbao.modules.mq;


import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShInstructionParsingEntity;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("wasteParse")
public class WasteParse implements IParse {

    private final static Logger logger = LoggerFactory.getLogger(WasteParse.class);

    @Autowired
    private OtherShDeviceService otherShDeviceService;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private TimeParseUtils timeParseUtils;

    @Override
    public Map<String, String> run(Object o, Map<String, String> datas) {
        ShDeviceEntity device = (ShDeviceEntity) o;
        Map<String, String> ws = new HashMap<>();

        if("08".equals(datas.get("cmd"))) {//登录包
            redisUtils.set(datas.get("mac").toUpperCase(), datas.toString(), 180);//3分钟有效
            //校验设备时钟
            new Thread(new Runnable() {
                @Override
                public void run() {
                    logger.info("start checkDeviceTime");
                    timeParseUtils.checkDeviceTime1(datas.get("receiveId"), datas.get("content"), "04");
                }
            }).start();

            return datas;
        }else if("01".equals(datas.get("cmd")) || "07".equals(datas.get("cmd"))) {//实时数据上报

            String content = datas.get("content");

            //运行状态
            String eqh = content.substring(36, 38);
            String eq = String.valueOf(Integer.valueOf(eqh, 16));

            logger.error("运行状态 : {}, 紫外线状态 : {}, 温度 : {}, 紫外灯高温预警设定温度 : {}, 开关状态 : {}, 紫外灯低温预警设定温度 : {}, 开关状态 : {}",
                    eq, Integer.valueOf(content.substring(30, 32), 16), Integer.valueOf(content.substring(44, 46), 16)
                    , Integer.valueOf(content.substring(46, 48), 16), Integer.valueOf(content.substring(48, 50), 16)
                    , Integer.valueOf(content.substring(50, 52), 16), Integer.valueOf(content.substring(52, 54), 16));


            //查询解析指令集
            List<ShInstructionParsingEntity> cmds = otherShDeviceService.getDeviceInstructionList(device.getProductId(), datas.get("cmd"));
            if (cmds != null && cmds.size() > 0) {
                int length = 0;
                //解析设备报文内容
                String content1 = datas.get("content");
                Map<String, Object> map = new HashMap<>();
                for (ShInstructionParsingEntity cmd : cmds) {
                    String hex = content1.substring(length, length + cmd.getLength());
                    String hex1;
                    if (cmd.getType() == 1 || cmd.getType() == 2) {
                        hex1 = String.valueOf(Integer.valueOf(hex, 16));

                    }else {
                        hex1 = ByteUtils.signHex2IntString(hex);
                    }
                    map.put(cmd.getName(), hex1);
                    ws.put(cmd.getName(), hex1);
                    length += cmd.getLength();
                }
                otherShDeviceService.updateDeviceData(JSON.toJSONString(map), device.getId());
            } else {
                ws = datas;
            }
        }else if("18".equals(datas.get("cmd")) || "19".equals(datas.get("cmd"))) {//开关响应
            String content = datas.get("content");
            //响应状态
            String eqh = content.substring(0, 2);
            String eq = String.valueOf(Integer.valueOf(eqh, 16));
            ws.put("action", eq);
        }

        return ws;
    }

}
