/**
 * Copyright (c) 2016-2019 人人开源 All rights reserved.
 *
 * https://www.renren.io
 *
 * 版权所有，侵权必究！
 */

package tech.glinfo.enbao.modules.appuser.controller;


import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * APP测试接口
 *
 * @author Mark sunlightcs@gmail.com
 */
@RestController
@RequestMapping("/app")
@Api(value = "APP测试接口",description="APP测试接口")
public class AppTestController {
//
//    @Autowired
//    private MqProducer mqProducer;
//
//    @Login
//    @GetMapping("userInfo")
//    @ApiOperation("获取用户信息")
//    public R userInfo(@LoginUser AppUserEntity user){
//        return R.ok().put("user", user);
//    }

    @Login
    @GetMapping("userId")
    @ApiOperation("获取用户ID")
    public R userInfo(@RequestAttribute("userId") Integer userId){
        return R.ok().put("userId", userId);
    }

    @GetMapping("notToken")
    @ApiOperation("忽略Token验证测试")
    public R notToken(){
        return R.ok().put("msg", "无需token也能访问。。。");
    }

    @GetMapping("pushTest")
    @ApiOperation("推送测试")
    public R pushTest(@RequestParam Map<String, Object> params){
        String cid = (String) params.get("cid");
        String title = (String) params.get("title");
        String msg = (String) params.get("msg");
        if(!StringUtils.isBlank(cid, title, msg)) {
//            mqProducer.sendPush(title, msg, cid);
            return R.ok();
        }
        return R.error("缺少参数");
    }

}
