package tech.glinfo.enbao.modules.mq;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Component;
import tech.glinfo.enbao.modules.sh.form.ProtocolContent;

import javax.jms.Queue;
import javax.jms.Topic;
import java.util.HashMap;
import java.util.Map;

@Component
public class MqProducer {

    private final static Logger logger = LoggerFactory.getLogger(MqProducer.class);

    @Autowired
    private JmsMessagingTemplate jmsTemplate;

    @Autowired
    private Queue sendQueue;

    @Autowired
    private Queue sendPushQueue;

    @Autowired
    private Topic sendTopic;

    @Autowired
    private Topic socketioTopic;

    /**
     * 发送队列
     * @param message
     */
    public void sendQ(String message) {
        jmsTemplate.convertAndSend(sendQueue, message);
//        logger.info("Message was sent to the Queue : {}", message);
    }

    /**
     * 发送主题
     * @param message
     */
    public void sendT(String message) {
        jmsTemplate.convertAndSend(sendTopic, message);
//        logger.info("Message was sent to the topic : {}", message);
    }

    /**
     * 发送socketio主题
     * @param message
     */
    public void sendSocketioT(String message) {
        jmsTemplate.convertAndSend(socketioTopic, message);
//        logger.info("Message was sent to the topic : {}", message);
    }

    /**
     * 发送推送序列
     * @param title 标题
     * @param content 内容
     * @param clientId 客户端ID
     * json字符串,如：{title:"认证审核结果",content:"恭喜您，你的售后接单人认证通过了！",clientId:"1234567890"}
     * clientId:app_user表thirdid字段
     */
    public void sendPush(String title, String content, String clientId) {
        Map<String, String> push = new HashMap<>();
        push.put("title", title);
        push.put("content", content);
        push.put("clientId", clientId);
        String message = JSON.toJSONString(push);
        jmsTemplate.convertAndSend(sendPushQueue, message);
//        logger.info("Message was sent to the queue : {}", message);
    }

    public void sendCmd(String cmd, String numbering, String deviceType, String content) {
        ProtocolContent protocol = new ProtocolContent();
        protocol.setCmd(cmd);
        protocol.setDeviceType(deviceType);
        protocol.setReceiveId(numbering);
        protocol.setContent(content);
        sendT(JSON.toJSONString(protocol));
    }
}
