package tech.glinfo.enbao.modules.sh.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.appuser.service.AppUserService;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyInviteEntity;
import tech.glinfo.enbao.modules.sh.entity.ShFamilyMemberEntity;
import tech.glinfo.enbao.modules.sh.service.ShFamilyInviteService;
import tech.glinfo.enbao.modules.sh.service.ShFamilyMemberService;

import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/shFamilyInvite")
@Api(value = "邀请家庭成员")
public class ShFamilyInviteController {

    @Autowired
    private ShFamilyInviteService shFamilyInviteService;

    @Autowired
    private ShFamilyMemberService shFamilyMemberService;

    @Autowired
    private AppUserService appUserService;

    @Login
    @PostMapping("add")
    @ApiOperation("新增")
    @ApiLog("新增")
    public R add(@RequestBody Map<String, Object> params, @LoginUser AppUserEntity user) {
        String phone = (String) params.get("phone");
        String name = (String) params.get("name");
        Integer familyId = (Integer) params.get("familyId");
        if (StringUtils.isBlank(familyId, name)) {
            return R.error("缺少参数");
        }
        if (StringUtils.isBlank(phone)) {
            return R.error("请输入邀请成员手机号码");
        }
        AppUserEntity appUser = appUserService.getOne(new QueryWrapper<AppUserEntity>().eq("phone", phone));
        if (appUser == null) {
            return R.error("成员还未注册");
        }
        int count = shFamilyMemberService.count(new QueryWrapper<ShFamilyMemberEntity>().eq("user_id", appUser.getId()).eq("family_id", familyId));
        if (count > 0) {
            return R.error("成员已经加入");
        }

        int count1 = shFamilyInviteService.count(new QueryWrapper<ShFamilyInviteEntity>().eq("status", 1).eq("family_id", familyId).eq("user_id", appUser.getId()));
        //判断是否重复邀请
        if (count1 == 0) {
            ShFamilyInviteEntity invite = new ShFamilyInviteEntity();
            invite.setFamilyId(familyId);
            invite.setCreateId(user.getId());
            invite.setUserId(appUser.getId());
            invite.setName(name);
            shFamilyInviteService.save(invite);
        }
        return R.ok();
    }


    @Login
    @GetMapping("list")
    @ApiOperation("邀请列表")
    @ApiLog("邀请列表")
    public R list(@LoginUser AppUserEntity user) {
        List<ShFamilyInviteEntity> list = shFamilyInviteService.list(new QueryWrapper<ShFamilyInviteEntity>().eq("user_id", user.getId()));
        return R.ok().put("list", list);
    }

    @Login
    @PostMapping("updateStatus")
    @ApiOperation("修改状态")
    @ApiLog("修改状态")
    public R updateStatus(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        Integer status = (Integer) params.get("status");
        if (StringUtils.isBlank(id, status)) {
            return R.error("缺少参数");
        }
        ShFamilyInviteEntity invite = shFamilyInviteService.getById(id);
        if (invite != null && invite.getStatus() == 1) {
            invite.setStatus(status);
            if (status == 2) {
                ShFamilyMemberEntity member = new ShFamilyMemberEntity();
                member.setFamilyId(invite.getFamilyId());
                member.setUserId(invite.getUserId());
                member.setIsAdmin(2);
                shFamilyMemberService.save(member);
            }
            shFamilyInviteService.updateById(invite);
        }
        return R.ok();
    }

}