package tech.glinfo.enbao.modules.sh.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.utils.ByteUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceEntity;
import tech.glinfo.enbao.modules.sh.entity.ShDeviceTempEntity;
import tech.glinfo.enbao.modules.sh.form.ProtocolContent;
import tech.glinfo.enbao.modules.sh.form.ShDeviceTempForm;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceService;
import tech.glinfo.enbao.modules.sh.service.OtherShDeviceTempService;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;


@RestController
@RequestMapping("/shDeviceTemp")
@Api(value = "智能家居定时")
public class ShDeviceTempController {

    private final static Logger logger = LoggerFactory.getLogger(ShDeviceTempController.class);
    @Autowired
    private OtherShDeviceTempService otherShDeviceTempService;

    @Autowired
    private OtherShDeviceService otherShDeviceService;

    @Autowired
    private RedisUtils redisUtils;

    @Login
    @PostMapping("saveOrUpdate")
    @ApiOperation("新增、修改(智能插座)")
    @ApiLog("新增、修改(智能插座)")
    public R saveOrUpdate(@RequestBody ShDeviceTempForm form) throws InvocationTargetException, IllegalAccessException {
        //表单校验
        ValidatorUtils.validateEntity(form);
        ShDeviceTempEntity tempEntity = new ShDeviceTempEntity();
        BeanUtils.copyProperties(tempEntity, form);
        otherShDeviceTempService.saveOrUpdate(tempEntity);
        ShDeviceEntity entity = otherShDeviceService.getById(form.getDeviceId());
        String content;
        String tempH = ByteUtils.signInt2HexString(form.getTempH().toString(), 2);
        String tempL = ByteUtils.signInt2HexString(form.getTempL().toString(), 2);
        content = tempH + ByteUtils.int2Hex(form.getStatusH()) + tempL + ByteUtils.int2Hex(form.getStatusL()) +
                "00000000";

        ProtocolContent protocol = new ProtocolContent();
        protocol.setReceiveId(entity.getNumbering());
        protocol.setDeviceType("03");
        protocol.setCmd("1A");
        protocol.setContent(content);
        String json = JSON.toJSONString(protocol);
        redisUtils.set("device:sendtemp:" + entity.getNumbering(), json);
        return R.ok().put("id", tempEntity.getId());
    }


    @Login
    @PostMapping("saveOrUpdate1")
    @ApiOperation("新增、修改温控(智能开关)")
    @ApiLog("新增、修改温控(智能开关)")
    public R saveOrUpdate1(@RequestBody ShDeviceTempForm form) throws InvocationTargetException, IllegalAccessException {
        //表单校验
        ValidatorUtils.validateEntity(form);
        ShDeviceTempEntity tempEntity = new ShDeviceTempEntity();
        BeanUtils.copyProperties(tempEntity, form);
        otherShDeviceTempService.saveOrUpdate(tempEntity);
        ShDeviceEntity entity = otherShDeviceService.getById(form.getDeviceId());

        String content;
        String tempH = ByteUtils.signInt2HexString(form.getTempH().toString(), 2);
        String tempL = ByteUtils.signInt2HexString(form.getTempL().toString(), 2);
        String tempHT = ByteUtils.signInt2HexString(form.getTempHT().toString(), 2);
        String tempLT = ByteUtils.signInt2HexString(form.getTempLT().toString(), 2);
        content = tempH + ByteUtils.int2Hex(form.getStatusH()) + tempL + ByteUtils.int2Hex(form.getStatusL()) +
                tempHT + ByteUtils.int2Hex(form.getStatusHT()) + tempLT + ByteUtils.int2Hex(form.getStatusLT());

        ProtocolContent protocol = new ProtocolContent();
        protocol.setReceiveId(entity.getNumbering());
        protocol.setDeviceType("02");
        protocol.setCmd("1A");
        protocol.setContent(content);
        String json = JSON.toJSONString(protocol);
        redisUtils.set("device:sendtemp:" + entity.getNumbering(), json);

        return R.ok().put("id", tempEntity.getId());
    }


    @Login
    @GetMapping("info/{id}")
    @ApiOperation("定时详情(智能插座、开关、窗帘)")
    @ApiLog("定时详情")
    public R info(@PathVariable("id") Integer id) {
        return R.ok().put("temp", otherShDeviceTempService.getOne(new QueryWrapper<ShDeviceTempEntity>().eq("device_id", id)));
    }

}