package tech.glinfo.enbao.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {

    private final static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    /**
     * 文网络件转换
     * @param filePath 文件路径
     * @return
     */
    public static List<Object> convertToHex(String filePath) {

        List<Object> datas = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        try {
            URL url = new URL(filePath);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置超时间为5秒
            conn.setConnectTimeout(5 * 1000);
//            int contentLength = conn.getContentLength();
//            logger.info("文件大小：{}" , contentLength);
            is = conn.getInputStream();

            byte[] buffer = new byte[10240];

            int len = 0;
            bos = new ByteArrayOutputStream();
            while((len = is.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] bytes = bos.toByteArray();

            datas = getDatas(bytes);

        } catch (IOException e) {
            logger.error("读取文件出错了：{}", e.getMessage());
        } finally {
            if(is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    logger.error("关闭文件输入流出错：{}", e.getMessage());
                }
            }
            if(bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    logger.error("关闭文件输出流出错：{}", e.getMessage());
                }
            }
        }

        logger.info("文件包数：{}", datas.size());

        return datas;
    }

    /**
     * 本地文件转换
     * @param filePath 文件路径
     * @return
     */
    public static List<Object> convertToHex1(String filePath) {

        List<Object> datas = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        try {
            is = new FileInputStream(filePath);
            byte[] buffer = new byte[10240];

            int len = 0;
            bos = new ByteArrayOutputStream();
            while((len = is.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] bytes = bos.toByteArray();
            datas = getDatas(bytes);

        } catch (IOException e) {
            logger.error("读取文件出错了：{}", e.getMessage());
        } finally {
            if(is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    logger.error("关闭文件输入流出错：{}", e.getMessage());
                }
            }
            if(bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    logger.error("关闭文件输出流出错：{}", e.getMessage());
                }
            }
        }

        logger.info("文件包数：{}", datas.size());

        return datas;
    }

    public static List<Object> getDatas(byte[] bytes) {
        //计算包数
        int length = bytes.length;
        List<Object> datas;//文件信息
        datas = new ArrayList<>();
        datas.add(StringUtils.appendString(ByteUtils.int2Hex(length), 8, true, "0"));

        int mod = length % 1024;
        int cnt = length / 1024;
        if(mod != 0) {
            cnt++;
        }
        for(int i=0; i<cnt; i++) {
            byte[] bytes1 = null;
            if((i+1) * 1024 > length) {
                bytes1 = subBytes(bytes, i*1024, length-i*1024);
                datas.add(StringUtils.appendString(ByteUtils.bytes2HexString(bytes1), 2048, false, "0"));
            } else {
                bytes1 = subBytes(bytes, i*1024, 1024);
                datas.add(ByteUtils.bytes2HexString(bytes1));
            }
        }
        return datas;
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }
}
