DROP TABLE IF EXISTS `app_user`;

CREATE TABLE `app_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `phone` varchar(11) DEFAULT NULL COMMENT '手机号码',
  `third_id` varchar(64) DEFAULT NULL COMMENT '第三方ID',
  `open_id` varchar(255) DEFAULT NULL COMMENT '微信openid',
  `union_id` varchar(64) DEFAULT NULL COMMENT 'unionid',
  `password` varchar(100) DEFAULT NULL COMMENT '密码',
  `nickname` varchar(50) DEFAULT NULL COMMENT '昵称',
  `head_img_url` text DEFAULT NULL COMMENT '头像',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1正常;2禁用]',
  `last_login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_user_phone` (`phone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='APP用户';

DROP TABLE IF EXISTS `app_api_log`;
CREATE TABLE `app_api_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `userid` int(11) COMMENT '用户',
  `phone` varchar(11) COMMENT '手机号码',
  `operation` varchar(50) COMMENT '用户操作',
  `method` varchar(200) COMMENT '请求方法',
  `params` text COMMENT '请求参数',
  `time` bigint NOT NULL COMMENT '执行时长(毫秒)',
  `ip` varchar(64) COMMENT 'IP地址',
  `create_date` datetime COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `app_api_log_phone` (`phone`) USING BTREE
) ENGINE=`InnoDB` DEFAULT CHARACTER SET utf8mb4 COMMENT='API日志';

CREATE TABLE `sh_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL COMMENT '分类名称',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品分类';

CREATE TABLE `sh_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '分类ID',
  `name` varchar(64) DEFAULT NULL COMMENT '产品名称',
  `category_name` varchar(64) NOT NULL COMMENT '分类名称',
  `pic` varchar(255) DEFAULT NULL COMMENT '图片',
  `device_flag` varchar(55) DEFAULT NULL COMMENT '设备标识',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_product_category_id` (`category_id`) USING BTREE,
  KEY `sh_product_device_flag` (`device_flag`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品';

CREATE TABLE `sh_instruction_parsing` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `product_id` int(11) DEFAULT NULL COMMENT '所属产品',
  `name` varchar(30) DEFAULT NULL COMMENT '名称',
  `length` int(11) NOT NULL COMMENT '长度',
  `type` tinyint(2) DEFAULT '1' COMMENT '类型[1整数;2字符串;]',
  `sort` int(11) NOT NULL COMMENT '排序',
  `cmd` varchar(50) DEFAULT NULL COMMENT '指令',
  `note` varchar(100) DEFAULT NULL COMMENT '备注',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_instruction_parsing_product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='指令解析';

CREATE TABLE `sh_family` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL COMMENT '家庭名称',
  `user_id` int(11) DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_family_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='家庭管理';

CREATE TABLE `sh_family_member` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `family_id` int(11) DEFAULT NULL COMMENT '家庭ID',
  `user_id` int(11) DEFAULT NULL COMMENT '成员ID',
  `is_admin` int(1) DEFAULT NULL COMMENT '是否管理员 1：是 2：否',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_family_member_family_id` (`family_id`) USING BTREE,
  KEY `sh_family_member_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='家庭成员';

CREATE TABLE `sh_family_room` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `family_id` int(11) DEFAULT NULL COMMENT '家庭ID',
  `name` varchar(64) DEFAULT NULL COMMENT '家庭名称',
  `user_id` int(11) DEFAULT NULL COMMENT '创建人',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_family_room_user_id` (`user_id`) USING BTREE,
  KEY `sh_family_room_family_id` (`family_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='家庭房间管理';

CREATE TABLE `sh_device` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `user_id` int(11) DEFAULT NULL COMMENT '发布人',
  `family_id` int(11) DEFAULT NULL COMMENT '家庭ID',
  `room_id` int(11) DEFAULT NULL COMMENT '房间ID',
  `mac` varchar(255) DEFAULT NULL COMMENT 'mac',
  `numbering` varchar(50) DEFAULT NULL COMMENT '设备编号',
  `numbering_flag` varchar(50) DEFAULT NULL COMMENT '编号标识',
  `name` varchar(50) DEFAULT NULL COMMENT '设备名称',
  `product_id` int(11) DEFAULT NULL COMMENT '所属产品',
  `online_status` tinyint(2) DEFAULT '1' COMMENT '在线状态 1:新增 2:在线 3:离线',
  `pic` varchar(255) DEFAULT NULL COMMENT '主图',
  `online_time` datetime DEFAULT NULL COMMENT '上线时间',
  `spare_one` varchar(55) DEFAULT NULL COMMENT '备用字段',
  `spare_two` varchar(55) DEFAULT NULL COMMENT '备用字段',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_numbering` (`numbering`) USING BTREE,
  KEY `sh_device_mac` (`mac`) USING BTREE,
  KEY `sh_device_family_id` (`family_id`) USING BTREE,
  KEY `sh_device_room_id` (`room_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居设备管理';

CREATE TABLE `sh_device_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) NOT NULL COMMENT '设备ID',
  `value` varchar(1000) NOT NULL COMMENT '值',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_data_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设备数据';

CREATE TABLE `sh_device_password` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) NOT NULL COMMENT '设备ID',
  `password` varchar(55) DEFAULT NULL COMMENT '临时密码',
  `status` tinyint(2) DEFAULT '1' COMMENT '下发标志 1未发 2已发',
  `type` tinyint(2) DEFAULT '1' COMMENT '类型 1动态密码 2临时密码',
  `expired_time` datetime DEFAULT NULL COMMENT '过期时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_password_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能锁临时密码';

CREATE TABLE `sh_device_power` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `total_duration` int(11) DEFAULT NULL COMMENT '总时长',
  `total_power` int(11) DEFAULT NULL COMMENT '总电量',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_power_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居电量表';

CREATE TABLE `sh_device_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `action` tinyint(2) DEFAULT NULL COMMENT '2：密码开锁 3：卡片开锁 14：人脸开锁 15：掌纹开锁 ',
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_record_device_id` (`device_id`) USING BTREE,
  KEY `sh_device_record_remark` (`remark`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居记录表';

CREATE TABLE `sh_device_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `temp_h` int(10) DEFAULT NULL COMMENT '高温',
  `minute_h` int(10) DEFAULT NULL COMMENT '分钟',
  `second_h` int(10) DEFAULT NULL COMMENT '秒',
  `temp_l` int(10) DEFAULT NULL COMMENT '高温',
  `minute_l` int(10) DEFAULT NULL COMMENT '分钟',
  `second_l` int(10) DEFAULT NULL COMMENT '秒',
  `temp_h_t` int(10) DEFAULT NULL COMMENT '高温',
  `minute_h_t` int(10) DEFAULT NULL COMMENT '分钟',
  `second_h_t` int(10) DEFAULT NULL COMMENT '秒',
  `temp_l_t` int(10) DEFAULT NULL COMMENT '高温',
  `minute_l_t` int(10) DEFAULT NULL COMMENT '分钟',
  `second_l_t` int(10) DEFAULT NULL COMMENT '秒',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status` tinyint(2) DEFAULT '2' COMMENT '状态 1开 2关',
  `status_t` tinyint(2) DEFAULT '2' COMMENT '状态 1开 2关',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_temp_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='设备温度控制';

CREATE TABLE `sh_device_timing` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `repeats` tinyint(2) DEFAULT '0' COMMENT '状态 0:一次 1:多次',
  `time` varchar(50) DEFAULT NULL COMMENT '打开时间 重复一次时间：1111-04-11 15:12;重复多次时间：15:11',
  `repeat_time` varchar(50) DEFAULT NULL COMMENT '重复时间 1 2 3 4 5 6 7',
  `action` tinyint(2) DEFAULT NULL COMMENT '开关1:1为选中，其他为不选中',
  `action_two` tinyint(2) DEFAULT NULL COMMENT '开关2:1为选中，其他为不选中',
  `close_time` varchar(64) DEFAULT NULL COMMENT '关闭时间 重复一次时间：1111-04-11 15:12;重复多次时间：15:11',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `status` tinyint(2) DEFAULT '2' COMMENT '状态 1开 2关',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_device_timing_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能家居定时表';

CREATE TABLE `sh_speaker_song` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` int(11) DEFAULT NULL COMMENT '设备ID',
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `name` varchar(255) DEFAULT NULL COMMENT '歌名',
  `status` tinyint(2) DEFAULT '2' COMMENT '状态 1显示 2不显示',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_speaker_song_device_id` (`device_id`) USING BTREE,
  KEY `sh_speaker_song_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='智能音箱歌曲';

CREATE TABLE `sh_speaker_first_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `keyword` varchar(55) NOT NULL COMMENT '关键字',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能音箱一级关键字';

CREATE TABLE `sh_speaker_secondary_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `parent_id` int(11) DEFAULT NULL COMMENT '父ID',
  `keyword` varchar(55) NOT NULL COMMENT '关键字',
  `cmd` varchar(110) NOT NULL COMMENT '命令',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `secondary_keywords_parent_id` (`parent_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='智能音箱二级关键字';

CREATE TABLE `parse_class` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `type` varchar(55) NOT NULL COMMENT '类型',
  `class_name` varchar(55) DEFAULT NULL COMMENT '类名',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接收设备消息对应类';


CREATE TABLE `sh_dlink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `title` varchar(50) DEFAULT NULL COMMENT '标题',
  `start` varchar(10) DEFAULT NULL COMMENT '生效时间段-开始',
  `end` varchar(10) DEFAULT NULL COMMENT '生效时间段-结束',
  `device_id` int(11) DEFAULT NULL COMMENT '发起设备ID',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1开启，2关闭]',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_dlink_user_id` (`user_id`) USING BTREE,
  KEY `sh_dlink_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='智能家居场景';

CREATE TABLE `sh_dlink_device` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dlink_id` int(11) DEFAULT NULL COMMENT '场景ID',
  `device_id` int(11) DEFAULT NULL COMMENT '关联设备ID',
  `cmd` text COMMENT '指令',
  `status` tinyint(2) DEFAULT '1' COMMENT '状态[1开启，2关闭]',
  `status2` tinyint(2) DEFAULT NULL COMMENT '状态[1开启，2关闭]',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sh_dlink_device_dlink_id` (`dlink_id`) USING BTREE,
  KEY `sh_dlink_device_device_id` (`device_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='智能家居场景关联设备';

CREATE TABLE `help_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(64) DEFAULT NULL COMMENT '标题',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='帮助中心';

CREATE TABLE `help_center_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `help_id` int(11) DEFAULT NULL COMMENT '帮助中心ID',
  `content` text COMMENT '内容',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='帮助中心内容';

CREATE TABLE `feed_back` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(50) DEFAULT NULL COMMENT '联系人',
  `phone` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `content` varchar(255) DEFAULT NULL COMMENT '意见/建议内容',
  `pic` text COMMENT '反馈图片',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '反馈时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='意见反馈';

CREATE TABLE `business_cooperation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(50) DEFAULT NULL COMMENT '联系人',
  `phone` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `content` varchar(255) DEFAULT NULL COMMENT '内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商务合作';

alter table sh_family_member add `status` tinyint(2) DEFAULT '1' COMMENT '状态[1待确认，2已加入，2已拒绝]' after `is_admin` ;
alter table sh_family_member add `invite_id` int(11) DEFAULT NULL COMMENT '邀请人ID' after `status` ;
