package tech.glinfo.enbao.modules.infrared.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.MapUtils;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.StringUtils;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.infrared.entity.InfraredControlEntity;
import tech.glinfo.enbao.modules.infrared.form.InfraredControlForm;
import tech.glinfo.enbao.modules.infrared.service.OtherInfraredControlService;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;


/**
 * 用户遥控器
 *
 * @author linzhenjie
 * @email linzhenjie@gltech.com
 * @date 2021-07-27 10:33:36
 */
@RestController
@RequestMapping("/infraredControl")
@Api(value = "用户遥控器")
public class InfraredControlController {

    private final static Logger logger = LoggerFactory.getLogger(InfraredControlController.class);

    @Autowired
    private OtherInfraredControlService otherInfraredControlService;

    @Login
    @GetMapping("list")
    @ApiOperation("查询用户遥控器")
    @ApiLog("查询用户遥控器")
    public R list(@RequestParam Map<String, Object> params, @LoginUser AppUserEntity user) {
        String deviceId = (String) params.get("deviceId");
        if (StringUtils.isNotBlank(deviceId)) {
            return R.ok().put("list",  otherInfraredControlService.list(new QueryWrapper<InfraredControlEntity>().eq("device_id", deviceId)));

        }else {
            return R.ok().put("list",  otherInfraredControlService.list(new QueryWrapper<InfraredControlEntity>().eq("user_id", user.getId())));

        }
    }

    @Login
    @GetMapping("info/{id}")
    @ApiOperation("遥控器信息")
    @ApiLog("遥控器信息")
    public R info(@PathVariable("id") Integer id) {

        InfraredControlEntity entity = otherInfraredControlService.getById(id);
        return R.ok().put("info", entity);
    }


    @Login
    @PostMapping("save")
    @ApiOperation("保存用户遥控器")
    @ApiLog("保存用户遥控器")
    public R save(@LoginUser AppUserEntity user, @RequestBody InfraredControlForm form) throws InvocationTargetException, IllegalAccessException {
        //表单校验
        ValidatorUtils.validateEntity(form);
        InfraredControlEntity entity = new InfraredControlEntity();
        BeanUtils.copyProperties(entity, form);
        entity.setUserId(user.getId());
        boolean save = otherInfraredControlService.save(entity);
        //新增设备遥控==开关的
        if(form.getDeviceId() != null) {
            //空调
            if("空调".equals(form.getDeviceType()) || "电视".equals(form.getDeviceType())) {
                String deviceType = form.getDeviceType();
                String model = form.getModel();
                Integer deviceId = form.getDeviceId();
                String rtype = form.getRtype();
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        otherInfraredControlService.saveInfraredCode(deviceType, model, deviceId, rtype);
                    }
                }).start();
            }
        }

        return save ? R.ok(new MapUtils().put("id", entity.getId())) : R.error("新增失败");
    }

    @Login
    @PostMapping("update")
    @ApiOperation("修改用户遥控器")
    @ApiLog("修改用户遥控器")
    public R update(@RequestBody InfraredControlForm form) throws InvocationTargetException, IllegalAccessException {
        //表单校验
//        ValidatorUtils.validateEntity(form);
        if(StringUtils.isBlank(form.getRemark())){
            return R.error("遥控器名称必录！");
        }
        InfraredControlEntity entity = new InfraredControlEntity();
        BeanUtils.copyProperties(entity, form);
        return otherInfraredControlService.updateById(entity) ? R.ok() : R.error("更新失败");
    }


    @Login
    @PostMapping("delete")
    @ApiOperation("用户遥控器")
    @ApiLog("用户遥控器")
    public R delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer) params.get("id");
        InfraredControlEntity entity = otherInfraredControlService.getById(id);
        //删除红外缓存
        if(entity.getDeviceId() != null) {
            otherInfraredControlService.deleteInfraredCode(entity.getDeviceId(), entity.getDeviceType());
        }
        return otherInfraredControlService.removeById(id)? R.ok() : R.error("删除失败");
    }

}
