package tech.glinfo.enbao.modules.sys.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.sys.entity.BusinessCooperationEntity;
import tech.glinfo.enbao.modules.sys.form.BusinessCooperationForm;
import tech.glinfo.enbao.modules.sys.service.BusinessCooperationService;

import java.lang.reflect.InvocationTargetException;

/**
 * @author lyt
 * @date 2022/2/14 17:06
 */
@RestController
@RequestMapping("/sys/businessCooperation")
@Api(value = "商务合作")
public class BusinessCooperationController {

    @Autowired
    private BusinessCooperationService businessCooperationService;

    @PostMapping("save")
    @ApiOperation("商务合作")
    @ApiLog("商务合作")
    public R save(@RequestBody BusinessCooperationForm form) throws InvocationTargetException, IllegalAccessException {

        //表单校验
        ValidatorUtils.validateEntity(form);

        BusinessCooperationEntity entity = new BusinessCooperationEntity();
        BeanUtils.copyProperties(entity, form);
        businessCooperationService.save(entity);
        return R.ok();
    }
}
