package tech.glinfo.enbao.modules.sh.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.annotation.Login;
import tech.glinfo.enbao.common.annotation.LoginUser;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.sh.form.ShDlinkForm;
import tech.glinfo.enbao.modules.sh.service.OtherShDlinkService;

import java.util.Map;

/**
 * @author lyt
 * @date 2021/9/1 9:52
 */
@RestController
@RequestMapping("shDlink")
@Api(value = "房源-地址")
public class ShDlinkController {

    @Autowired
    private OtherShDlinkService otherShDlinkService;

    @Login
    @PostMapping("/save")
    @ApiOperation("保存房源场景")
    @ApiLog("保存房源场景")
    public R save(@RequestBody ShDlinkForm form, @LoginUser AppUserEntity user) {
        //表单校验
        ValidatorUtils.validateEntity(form);
        return otherShDlinkService.save(form, user);
    }


    @Login
    @GetMapping("/info/{id}")
    @ApiOperation("详情")
    @ApiLog("详情")
    public R info(@PathVariable("id") Integer id) {
        return otherShDlinkService.info(id);
    }



    @Login
    @GetMapping("/list")
    @ApiOperation("列表")
    @ApiLog("列表")
    public R list1(@LoginUser AppUserEntity user) {
        return otherShDlinkService.list(user.getId());
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation("删除房源场景")
    @ApiLog("删除房源场景")
    public R delete(@RequestBody Map<String, Object> params) {
        return otherShDlinkService.delete((Integer) params.get("id"));
    }


    @Login
    @PostMapping("/updateStatus")
    @ApiOperation("修改房源场景状态")
    @ApiLog("修改房源场景状态")
    public R updateStatus(@RequestBody Map<String, Object> params) {
        return otherShDlinkService.updateStatus((Integer) params.get("id"), (Integer) params.get("status"));
    }

    @Login
    @GetMapping("/dlinkDeviceList/{id}")
    @ApiOperation("场景关联的设备列表")
    @ApiLog("场景关联的设备列表")
    public R dlinkDeviceList(@PathVariable("id") Integer id) {
        return otherShDlinkService.dlinkDeviceList(id);
    }


}
