package tech.glinfo.enbao.modules.appuser.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;
import tech.glinfo.enbao.common.exception.RRException;
import tech.glinfo.enbao.common.utils.PageUtils;
import tech.glinfo.enbao.common.utils.Query;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.utils.RedisUtils;
import tech.glinfo.enbao.common.validator.Assert;
import tech.glinfo.enbao.modules.appuser.dao.AppUserDao;
import tech.glinfo.enbao.modules.appuser.entity.AppUserEntity;
import tech.glinfo.enbao.modules.appuser.form.LoginForm;
import tech.glinfo.enbao.modules.appuser.form.QuickLoginForm;
import tech.glinfo.enbao.modules.appuser.service.OtherAppUserService;

import java.util.*;


@Service("otherAppUserService")
public class OtherAppUserServiceImpl extends ServiceImpl<AppUserDao, AppUserEntity> implements OtherAppUserService {


    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        IPage<AppUserEntity> page = this.page(
                new Query<AppUserEntity>().getPage(params),
                new QueryWrapper<AppUserEntity>()
        );

        return new PageUtils(page);
    }

    @Override
    public AppUserEntity queryByPhone(String phone) {
        return this.getOne(new QueryWrapper<AppUserEntity>().eq("phone", phone));
    }

    @Override
    public AppUserEntity login(LoginForm form) {
        AppUserEntity user = queryByPhone(form.getPhone());
        Assert.isNull(user, "手机号码或密码错误");

        //密码错误
        if (!user.getPassword().equals(DigestUtils.sha256Hex(form.getPassword()))) {
            throw new RRException("手机号码或密码错误");
        }

        if(user.getStatus() != 1) {
            throw new RRException("该号码已被禁用");
        }

        return user;
    }

    @Override
    public AppUserEntity quickLogin(QuickLoginForm form) {
        AppUserEntity user = queryByPhone(form.getPhone());
        if (user == null) {
            return null;
        }
//        Assert.isNull(user, "该账号不存在，请核查");
        if(user.getStatus() != 1) {
            throw new RRException("该号码已被禁用");
        }
        return user;
    }

   /* @Override
    public R updateStatus(Integer userId, String phone) {
        return this.baseMapper.updateStatus(userId, phone) > 0 ? R.ok() : R.error("注销失败");
    }*/


}