package tech.glinfo.enbao.modules.sys.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.glinfo.enbao.common.annotation.ApiLog;
import tech.glinfo.enbao.common.utils.R;
import tech.glinfo.enbao.common.validator.ValidatorUtils;
import tech.glinfo.enbao.modules.sys.entity.FeedBackEntity;
import tech.glinfo.enbao.modules.sys.form.FeedBackForm;
import tech.glinfo.enbao.modules.sys.service.FeedBackService;

import java.lang.reflect.InvocationTargetException;

/**
 * @author lyt
 * @date 2022/2/14 17:06
 */
@RestController
@RequestMapping("/sys/feedBack")
@Api(value = "意见反馈")
public class FeedBackController {

    @Autowired
    private FeedBackService feedBackService;

    @PostMapping("save")
    @ApiOperation("意见反馈")
    @ApiLog("意见反馈")
    public R save(@RequestBody FeedBackForm form) throws InvocationTargetException, IllegalAccessException {

        //表单校验
        ValidatorUtils.validateEntity(form);

        FeedBackEntity entity = new FeedBackEntity();
        BeanUtils.copyProperties(entity, form);
        feedBackService.save(entity);
        return R.ok();
    }
}
