package tech.glinfo.enbao.modules.sh.form;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ProtocolContent {

    @ApiModelProperty(value = "接收设备ID")
    @NotNull(message="接收设备ID不能为空")
    private String deviceId;

    private String receiveId;

    @ApiModelProperty(value = "设备类型[01:空气净化器]")
    @NotBlank(message="设备类型不能为空")
    private String deviceType;

    @ApiModelProperty(value = "下发指令")
    @NotBlank(message="下发指令不能为空")
    private String cmd;

    @ApiModelProperty(value = "指令内容")
    @NotBlank(message="指令内容不能为空")
    private String content;

}
