package tech.glinfo.enbao.modules.service;

import org.json.JSONObject;

public interface BaiduApiService {

    /**
     * 人脸身份验证
     * 百度SDK地址：https://ai.baidu.com/ai-doc/FACE/8k37c1rqz#%E8%BA%AB%E4%BB%BD%E9%AA%8C%E8%AF%81
     * @param image 人脸图片base64字符串
     * @param idCardNumber 身份证号码
     * @param name 姓名
     * @return
     */
    JSONObject personVerify(String image, String idCardNumber, String name);

    /**
     * 两张人脸比对
     * @param image1
     * @param image2
     * @return
     */
    JSONObject match(String image1, String image2);

    /**
     * 语音合成
     * 合成文本长度必须小于1024字节，每120个字节算一次计费
     * 百度SDK地址：https://ai.baidu.com/ai-doc/SPEECH/Mk4nlz5am
     * @param text 需要转语音的文字
     * @return
     */
    byte[] synthesis(String text);


    /**
     * 创建用户组
     * @param groupId 如果多个逗号隔开
     * @return
     */
    JSONObject groupAdd(String groupId);


    /**
     * 人脸注册
     * @param image 图片base64
     * @param groupId 如果多个逗号隔开
     * @return
     */
    JSONObject addUser(String image, String userId, String groupId, String userInfo);


    /**
     * 人脸更新
     * @param image 图片base64
     * @param groupId 如果多个逗号隔开
     * @return
     */
    JSONObject updateUser(String image, String userId, String groupId, String userInfo);


    /**
     * 人脸删除
     * @param userId 图片base64
     * @param groupId 如果多个逗号隔开
     * @param faceToken 需要删除的人脸图片token
     * @return
     */
    JSONObject delUser(String userId, String groupId, String faceToken);


    /**
     * 人脸检索
     * @param image 图片base64
     * @param groupId 如果多个逗号隔开
     * @return
     */
    JSONObject search(String image, String groupId);

    String chat(String text, String chatId);

}
